/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.components.CardSlotWidget;
import dev.lucaargolo.charta.client.gui.screens.CardScreen;
import dev.lucaargolo.charta.client.gui.screens.DeckScreen;
import dev.lucaargolo.charta.client.gui.screens.HistoryScreen;
import dev.lucaargolo.charta.client.gui.screens.MarkdownScreen;
import dev.lucaargolo.charta.client.gui.screens.OptionsScreen;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.network.CardContainerSlotClickPayload;
import dev.lucaargolo.charta.utils.CardPlayerHead;
import dev.lucaargolo.charta.utils.HoverableRenderable;
import dev.lucaargolo.charta.utils.MultiLineTooltip;
import dev.lucaargolo.charta.utils.TickableWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GameScreen<G extends CardGame<G>, T extends AbstractCardMenu<G>>
extends class_465<T>
implements HoverableRenderable {
    public static final class_2960 WIDGETS = Charta.id("textures/gui/widgets.png");
    private final List<CardSlotWidget<G>> slotWidgets = new ArrayList<CardSlotWidget<G>>();
    private HoverableRenderable hoverable = null;
    private CardSlot<G> hoveredCardSlot = null;
    private int hoveredCardId = -1;
    private final boolean areOptionsChanged;
    private final class_408 chatScreen = new class_408("");
    private boolean prevChatFocused = false;
    private boolean chatFocused = false;
    private class_4185 optionsButton;

    public GameScreen(T menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.areOptionsChanged = CardGames.areOptionsChanged(((AbstractCardMenu)((Object)menu)).getGameFactory(), ((AbstractCardMenu)((Object)menu)).getGame());
    }

    public CardDeck getDeck() {
        return ((AbstractCardMenu)this.field_2797).getDeck();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hoveredCardSlot != null) {
            ClientPlayNetworking.send((class_8710)new CardContainerSlotClickPayload(((AbstractCardMenu)this.field_2797).field_7763, this.hoveredCardSlot.index, this.hoveredCardId));
            return true;
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return this.chatScreen.method_25402(mouseX, this.chatFocused ? mouseY : mouseY + 25.0, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.chatFocused && this.chatScreen.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null && this.chatFocused) {
            if (keyCode == 257 || keyCode == 335) {
                this.chatScreen.method_44056(this.chatScreen.field_2382.method_1882(), true);
                this.chatFocused = false;
                return true;
            }
            if (this.chatScreen.method_25404(keyCode, scanCode, modifiers)) {
                if (keyCode == 256) {
                    this.field_22787.method_1507((class_437)this);
                    this.chatFocused = false;
                }
                return true;
            }
        }
        if (!this.chatFocused) {
            if (keyCode == 84) {
                this.chatFocused = true;
                this.chatScreen.field_2382.method_1852("");
                return false;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.field_22787 != null && this.prevChatFocused && this.chatFocused && this.chatScreen.method_25400(codePoint, modifiers)) {
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public final void method_25420(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void method_2388(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
    }

    protected void method_25426() {
        super.method_25426();
        assert (this.field_22787 != null);
        this.chatScreen.method_25423(this.field_22787, this.field_22789, this.field_22790);
        this.slotWidgets.clear();
        ((AbstractCardMenu)this.field_2797).cardSlots.forEach(slot -> this.slotWidgets.add(new CardSlotWidget(this, slot)));
        class_5250 rules = class_2561.method_43470((String)"\ue90e").method_27696(Charta.SYMBOLS);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)rules, b -> {
            class_2960 gameId = CardGames.getGameId(((AbstractCardMenu)this.field_2797).getGameFactory());
            class_310.method_1551().method_1507((class_437)new MarkdownScreen((class_2561)class_2561.method_43471((String)"message.charta.how_to_play").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)gameId.method_42094())), (class_437)this, gameId.method_12836() + ".how_to_play_" + gameId.method_12832()));
        }).method_46434(5, 35, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.how_to_play"))).method_46431());
        MultiLineTooltip tooltip = this.areOptionsChanged ? new MultiLineTooltip(new class_2561[]{class_2561.method_43471((String)"message.charta.game_options"), class_2561.method_43473(), class_2561.method_43471((String)"message.charta.custom_options").method_27692(class_124.field_1061)}) : class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.game_options"));
        class_5250 config = class_2561.method_43470((String)"\ue8b8").method_27696(Charta.SYMBOLS);
        this.optionsButton = (class_4185)this.method_37063((class_364)new class_4185.class_7840((class_2561)config, b -> {
            class_2960 gameId = CardGames.getGameId(((AbstractCardMenu)this.field_2797).getGameFactory());
            class_310.method_1551().method_1507(new OptionsScreen((class_437)this, class_2338.field_10980, ((AbstractCardMenu)this.field_2797).getGame(), gameId, ((AbstractCardMenu)this.field_2797).getGameFactory(), true));
        }).method_46434(27, 35, 20, 20).method_46436((class_7919)tooltip).method_46431());
        this.optionsButton.field_22763 = !((CardGame)((AbstractCardMenu)this.field_2797).getGame()).getOptions().isEmpty();
        class_5250 cards = class_2561.method_43470((String)"\ue41d").method_27696(Charta.SYMBOLS);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)cards, b -> class_310.method_1551().method_1507((class_437)new DeckScreen((class_437)this, this.getDeck()))).method_46434(this.field_22789 - 25, 35, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.game_deck"))).method_46431());
        class_5250 history = class_2561.method_43470((String)"\ue889").method_27696(Charta.SYMBOLS);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)history, b -> class_310.method_1551().method_1507((class_437)new HistoryScreen((class_437)this))).method_46434(this.field_22789 - 47, 35, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.game_history"))).method_46431());
    }

    public void renderTopBar(@NotNull class_332 guiGraphics) {
        Object game = ((AbstractCardMenu)this.field_2797).getGame();
        int players = ((CardGame)game).getPlayers().size();
        float totalWidth = CardSlot.getWidth(CardSlot.Type.PREVIEW) + 28.0f;
        float playersWidth = (float)players * totalWidth + ((float)players - 1.0f) * (totalWidth / 10.0f);
        guiGraphics.method_25294(0, 0, class_3532.method_15375((float)(((float)this.field_22789 - playersWidth) / 2.0f)), 28, -2013265920);
        guiGraphics.method_25294(this.field_22789 - class_3532.method_15375((float)(((float)this.field_22789 - playersWidth) / 2.0f)), 0, this.field_22789, 28, -2013265920);
        for (int i = 0; i < players; ++i) {
            CardPlayer player = ((CardGame)game).getPlayers().get(i);
            float x = (float)this.field_22789 / 2.0f - playersWidth / 2.0f + (float)i * (totalWidth + totalWidth / 10.0f);
            class_2561 text = player.getName();
            class_1767 color = player.getColor();
            guiGraphics.method_25294(class_3532.method_15375((float)x), 0, class_3532.method_15386((float)(x + totalWidth)), 28, -2013265920 + color.method_7787());
            if (i < players - 1) {
                guiGraphics.method_25294(class_3532.method_15386((float)(x + totalWidth)), 0, class_3532.method_15375((float)(x + totalWidth + totalWidth / 10.0f)), 28, -2013265920);
            }
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(x + 26.0f, 2.0f, 0.0f);
            guiGraphics.method_51448().method_22905(0.5f, 0.5f, 0.5f);
            guiGraphics.method_51439(this.field_22793, text, 0, 0, -1, true);
            guiGraphics.method_51448().method_22909();
            class_310 mc = class_310.method_1551();
            Function function = mc.method_1549(class_1723.field_21668);
            class_2960 wool = class_2960.method_60656((String)("block/" + color.method_7792() + "_wool"));
            class_1058 woolSprite = (class_1058)function.apply(wool);
            guiGraphics.method_25298((int)(x + 4.0f), 2, 0, 16, 1, woolSprite);
            guiGraphics.method_25298((int)(x + 2.0f), 3, 0, 20, 22, woolSprite);
            guiGraphics.method_25298((int)(x + 4.0f), 25, 0, 16, 1, woolSprite);
            CardPlayerHead.renderHead(guiGraphics, (int)x, 2, player);
        }
    }

    public void renderBottomBar(@NotNull class_332 guiGraphics) {
        CardPlayer player = ((AbstractCardMenu)this.field_2797).getCardPlayer();
        class_1767 color = player.getColor();
        int totalWidth = class_3532.method_15375((float)CardSlot.getWidth(CardSlot.Type.HORIZONTAL)) + 10;
        guiGraphics.method_25294(0, this.field_22790 - 63, (this.field_22789 - totalWidth) / 2, this.field_22790, -2013265920);
        guiGraphics.method_25294((this.field_22789 - totalWidth) / 2, this.field_22790 - 63, (this.field_22789 - totalWidth) / 2 + totalWidth, this.field_22790, -2013265920 + color.method_7787());
        guiGraphics.method_25294((this.field_22789 - totalWidth) / 2 + totalWidth, this.field_22790 - 63, this.field_22789, this.field_22790, -2013265920);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4068 renderable2;
        this.method_57734(partialTick);
        this.renderTopBar(guiGraphics);
        this.renderBottomBar(guiGraphics);
        this.method_2389(guiGraphics, partialTick, mouseX, mouseY);
        List renderablesBackup = List.copyOf(this.field_33816);
        this.hoveredCardSlot = null;
        for (int k = 0; k < ((AbstractCardMenu)this.field_2797).cardSlots.size(); ++k) {
            CardSlot slot = (CardSlot)((AbstractCardMenu)this.field_2797).cardSlots.get(k);
            if (this.isHoveringPrecise(slot, mouseX, mouseY)) {
                this.hoveredCardSlot = slot;
            }
            if (CardSlot.getWidth(slot) == 37.5f) {
                guiGraphics.method_25302(WIDGETS, this.field_2776 + (int)slot.x, this.field_2800 + (int)slot.y, 0, 0, 38, 53);
            }
            if (slot.getSlot().isEmpty()) continue;
            CardSlotWidget<G> slotWidget = this.slotWidgets.get(k);
            slotWidget.setPreciseX(slot.x + (float)this.field_2776);
            if (slot.getType() == CardSlot.Type.HORIZONTAL) {
                slotWidget.setPreciseY(slot.y + (float)this.field_22790 - slotWidget.getPreciseHeight());
            } else if (slot.getType() == CardSlot.Type.PREVIEW) {
                slotWidget.setPreciseY(slot.y);
            } else {
                slotWidget.setPreciseY(slot.y + (float)this.field_2800);
            }
            this.field_33816.add(slotWidget);
        }
        if (this.hoverable != null && !this.field_33816.contains(this.hoverable)) {
            this.hoverable = null;
        }
        for (class_4068 renderable2 : this.field_33816) {
            if (renderable2 == this.hoverable) continue;
            if (this.hoverable != null) {
                this.hoverable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
            renderable2.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (!(renderable2 instanceof class_339)) continue;
            class_339 widget = (class_339)renderable2;
            if (!(renderable2 instanceof HoverableRenderable) || !widget.field_22762) continue;
            HoverableRenderable hoverableRenderable = this.hoverable;
            if (hoverableRenderable instanceof class_339) {
                class_339 other = (class_339)hoverableRenderable;
                if (other.field_22762) continue;
            }
            this.hoverable = (HoverableRenderable)renderable2;
        }
        this.field_33816.clear();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.field_22787 != null && !this.chatFocused) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, -25.0f, 0.0f);
            double chatWidth = (Double)this.field_22787.field_1690.method_42556().method_41753();
            this.field_22787.field_1690.method_42556().method_41748((Object)(Math.min(chatWidth * 280.0, (double)this.field_22789 / 2.0 - (double)this.field_2792 / 2.0 - 50.0) / 280.0));
            this.field_22787.field_1705.method_1743().method_1805(guiGraphics, this.field_22787.field_1705.method_1738(), mouseX, mouseY + 25, false);
            this.field_22787.field_1690.method_42556().method_41748((Object)chatWidth);
            guiGraphics.method_51448().method_22909();
        }
        if (this.areOptionsChanged && this.optionsButton != null) {
            guiGraphics.method_25303(this.field_22793, "!", this.optionsButton.method_46426() + 16, this.optionsButton.method_46427() + 2, class_156.method_658() / 1000L % 2L == 0L ? 0xFF0000 : 0xFFFF00);
        }
        this.field_33816.addAll(renderablesBackup);
        if (this.hoverable != null) {
            this.hoverable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            renderable2 = this.hoverable;
            if (renderable2 instanceof class_339) {
                class_339 widget = (class_339)renderable2;
                if (!widget.field_22762) {
                    this.hoverable = null;
                }
            }
        }
        if (this.hoveredCardSlot != null && (renderable2 = this.hoverable) instanceof CardSlotWidget) {
            CardSlotWidget cardSlotWidget = (CardSlotWidget)renderable2;
            this.hoveredCardId = cardSlotWidget.getHoveredId();
        } else {
            this.hoveredCardId = -1;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        GameSlot cards = ((AbstractCardMenu)this.field_2797).getCarriedCards();
        if (!cards.isEmpty()) {
            CardSlotWidget<CardGame> carriedWidget = new CardSlotWidget<CardGame>(this, new CardSlot<CardGame>((CardGame)((AbstractCardMenu)this.field_2797).getGame(), g -> cards, (float)(mouseX - this.field_2776) - 18.75f, (float)(mouseY - this.field_2800) - 26.25f, CardSlot.Type.VERTICAL));
            carriedWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        CardScreen.renderGlowBlur((class_437)this, guiGraphics, partialTick);
        guiGraphics.method_51448().method_22909();
        if (this.chatFocused) {
            this.method_57734(partialTick);
            this.chatScreen.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void scheduleTooltip(class_2561 component) {
        this.method_47415(component);
    }

    public boolean isHoveredCardSlot(CardSlot<G> slot) {
        return this.hoveredCardSlot == slot;
    }

    private boolean isHoveringPrecise(CardSlot<G> slot, float mouseX, float mouseY) {
        return switch (slot.getType()) {
            case CardSlot.Type.HORIZONTAL -> this.isHoveringPrecise(slot.x, slot.y - (float)this.field_2800 + (float)this.field_22790 - CardSlot.getHeight(slot), CardSlot.getWidth(slot), CardSlot.getHeight(slot), mouseX, mouseY);
            case CardSlot.Type.PREVIEW -> this.isHoveringPrecise(slot.x, slot.y - (float)this.field_2800, CardSlot.getWidth(slot), CardSlot.getHeight(slot), mouseX, mouseY);
            default -> this.isHoveringPrecise(slot.x, slot.y, CardSlot.getWidth(slot), CardSlot.getHeight(slot), mouseX, mouseY);
        };
    }

    protected boolean isHoveringPrecise(float x, float y, float width, float height, double mouseX, double mouseY) {
        int i = this.field_2776;
        int j = this.field_2800;
        return (mouseX -= (double)i) >= (double)x && mouseX < (double)(x + width) && (mouseY -= (double)j) >= (double)y && mouseY < (double)(y + height);
    }

    public void method_37432() {
        super.method_37432();
        this.prevChatFocused = this.chatFocused;
        if (this.field_22787 != null) {
            int mouseX = (int)(this.field_22787.field_1729.method_1603() * (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480());
            int mouseY = (int)(this.field_22787.field_1729.method_1604() * (double)this.field_22787.method_22683().method_4502() / (double)this.field_22787.method_22683().method_4507());
            for (class_364 class_3642 : this.method_25396()) {
                if (!(class_3642 instanceof TickableWidget)) continue;
                TickableWidget tickable = (TickableWidget)class_3642;
                tickable.tick(mouseX, mouseY);
            }
            for (CardSlotWidget cardSlotWidget : this.slotWidgets) {
                cardSlotWidget.tick(mouseX, mouseY);
            }
        }
    }

    @Override
    @Nullable
    public HoverableRenderable getHoverable() {
        return this.hoverable;
    }
}

